//
//  NSArrayHelpers.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18.08.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

@interface NSArray (Helper)

- (NSArray *)filteredArrayUsingBlock:(BOOL (^)(id elt))filterBlock;

- (NSUInteger)countOfObjectsMatchingBlock:(BOOL (^)(id elt))filterBlock;

- (NSUInteger)countOfObjectsWithOptions:(NSEnumerationOptions)options matchingBlock:(BOOL (^)(id elt))filterBlock;

- (NSUInteger)countOfObjectsMatchingPredicate:(NSPredicate *)predicate;

- (NSUInteger)countOfObjectsWithOptions:(NSEnumerationOptions)options matchingPredicate:(NSPredicate *)predicate;

- (NSArray *)distinctValueForKey:(NSString *)key;

- (NSArray *)allCombinationsKeepOrder:(BOOL)keepOrder;

- (void)writeAsOldstylePropertyList:(NSString *)filePath;

- (void)makeObjectsPerformSelectorInParallel:(SEL)aSelector withObject:(id)arg;

- (void)enumerateObjectsInParallelUsingBlock:(void NS_NOESCAPE (^)(id obj, NSUInteger idx, BOOL* stop))block;

@end

@interface NSMutableArray (Reverse)

- (void)reverse;

@end
